<?php
/**
 * Dashboard template
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap wp-ssl-manager-dashboard">
    <h1><?php _e('SSL Certificate Manager', 'wp-ssl-manager'); ?></h1>
    
    <?php
    $api_url = get_option('wp_ssl_api_url');
    $client_id = get_option('wp_ssl_client_id');
    $client_secret = get_option('wp_ssl_client_secret');
    
    if (!$api_url || !$client_id || !$client_secret) {
        ?>
        <div class="notice notice-warning">
            <p><?php _e('Please configure your API credentials in Settings before using this plugin.', 'wp-ssl-manager'); ?></p>
            <p><a href="<?php echo admin_url('admin.php?page=wp-ssl-manager-settings'); ?>" class="button"><?php _e('Go to Settings', 'wp-ssl-manager'); ?></a></p>
        </div>
        <?php
        return;
    }
    ?>
    
    <div class="wp-ssl-manager-tabs">
        <nav class="nav-tab-wrapper">
            <a href="#generate" class="nav-tab nav-tab-active"><?php _e('Generate Certificate', 'wp-ssl-manager'); ?></a>
            <a href="#certificates" class="nav-tab"><?php _e('My Certificates', 'wp-ssl-manager'); ?></a>
        </nav>
        
        <!-- Generate Certificate Tab -->
        <div id="generate" class="tab-content active">
            <div class="wp-ssl-form">
                <h2><?php _e('Generate New SSL Certificate', 'wp-ssl-manager'); ?></h2>
                
                <form id="wp-ssl-generate-form">
                    <table class="form-table">
                        <tr>
                            <th><label for="domain"><?php _e('Domain', 'wp-ssl-manager'); ?> *</label></th>
                            <td>
                                <input type="text" id="domain" name="domain" class="regular-text" required 
                                       value="<?php echo esc_attr(parse_url(home_url(), PHP_URL_HOST)); ?>" 
                                       placeholder="example.com">
                                <p class="description"><?php _e('Enter the primary domain name (without http:// or https://)', 'wp-ssl-manager'); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="san_domains"><?php _e('SAN Domains', 'wp-ssl-manager'); ?></label></th>
                            <td>
                                <div id="san-domains-container">
                                    <input type="text" name="san_domains[]" class="regular-text san-domain-input" placeholder="www.example.com">
                                </div>
                                <button type="button" id="add-san-domain" class="button"><?php _e('Add Domain', 'wp-ssl-manager'); ?></button>
                                <p class="description"><?php _e('Add Subject Alternative Names (e.g., www.example.com)', 'wp-ssl-manager'); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="verification_method"><?php _e('Verification Method', 'wp-ssl-manager'); ?> *</label></th>
                            <td>
                                <select id="verification_method" name="verification_method" required>
                                    <option value="http-01"><?php _e('HTTP-01 (File Upload)', 'wp-ssl-manager'); ?></option>
                                    <option value="dns-01"><?php _e('DNS-01 (DNS Record)', 'wp-ssl-manager'); ?></option>
                                </select>
                                <p class="description"><?php _e('HTTP-01 is recommended and will be handled automatically by the plugin', 'wp-ssl-manager'); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="provider"><?php _e('SSL Provider', 'wp-ssl-manager'); ?> *</label></th>
                            <td>
                                <select id="provider" name="provider" required>
                                    <option value="letsencrypt"><?php _e('Let\'s Encrypt', 'wp-ssl-manager'); ?></option>
                                </select>
                            </td>
                        </tr>
                    </table>
                    
                    <p class="submit">
                        <button type="submit" class="button button-primary"><?php _e('Generate Certificate', 'wp-ssl-manager'); ?></button>
                    </p>
                </form>
                
                <div id="wp-ssl-generate-result" style="display: none;"></div>
            </div>
        </div>
        
        <!-- Certificates List Tab -->
        <div id="certificates" class="tab-content">
            <h2><?php _e('My Certificates', 'wp-ssl-manager'); ?></h2>
            <button id="refresh-certificates" class="button"><?php _e('Refresh', 'wp-ssl-manager'); ?></button>
            <div id="certificates-list">
                <p><?php _e('Loading certificates...', 'wp-ssl-manager'); ?></p>
            </div>
        </div>
    </div>
</div>

<script type="text/html" id="certificate-item-template">
    <div class="certificate-item" data-id="{{id}}">
        <h3>{{domain}} <span class="status-badge status-{{status}}">{{status}}</span></h3>
        <p><strong><?php _e('Provider:', 'wp-ssl-manager'); ?></strong> {{provider}}</p>
        <p><strong><?php _e('Created:', 'wp-ssl-manager'); ?></strong> {{created_at}}</p>
        {{#if expires_at}}
        <p><strong><?php _e('Expires:', 'wp-ssl-manager'); ?></strong> {{expires_at}}</p>
        {{/if}}
        
        <div class="certificate-actions">
            {{#if verifications}}
            <button class="button verify-btn" data-cert-id="{{id}}"><?php _e('Verify Domain', 'wp-ssl-manager'); ?></button>
            {{/if}}
            {{#if is_issued}}
            <button class="button download-btn" data-cert-id="{{id}}"><?php _e('Download', 'wp-ssl-manager'); ?></button>
            <button class="button install-btn" data-cert-id="{{id}}" data-domain="{{domain}}"><?php _e('Install via cPanel', 'wp-ssl-manager'); ?></button>
            {{/if}}
        </div>
        
        <div class="verification-details" style="display: none;">
            <h4><?php _e('Verification Instructions', 'wp-ssl-manager'); ?></h4>
            <div id="verification-{{id}}"></div>
        </div>
    </div>
</script>

